# Binance / OKX Integration – Secure Architecture

## Principles

- No API keys, secrets, or withdrawal logic in the frontend.
- All exchange communication is server-side.
- Keys stored in environment variables or a secrets manager, never in code or client.

## 1. Secure API key storage

- Store Binance and OKX API key + secret in environment variables (e.g. `BINANCE_API_KEY`, `BINANCE_API_SECRET`, `OKX_API_KEY`, `OKX_API_SECRET`, `OKX_PASSPHRASE` if required).
- Use a secrets manager (AWS Secrets Manager, HashiCorp Vault, GCP Secret Manager) in production and inject at runtime.
- Restrict exchange API keys to withdrawal-only permissions and IP allowlist if supported.
- Rotate keys periodically; support multiple keys for zero-downtime rotation.

## 2. Withdrawal queue

- When admin approves a withdrawal, insert into a withdrawal queue (DB table or message queue).
- Worker process (or cron) picks pending withdrawals and calls exchange API.
- Status: pending → processing → completed | failed.
- On failure, retry with backoff; after N failures, set status to failed and alert admin.

## 3. Manual approval toggle

- Admin approves each withdrawal in admin panel before it enters the queue.
- Optional: config flag to require second admin for amounts above threshold.
- No automatic payout without admin approval.

## 4. Webhook verification

- If using exchange webhooks for status updates, verify signature using shared secret (from env).
- Validate payload and idempotency (e.g. by external_id) before updating withdrawal status.

## 5. Transaction status tracking

- Store exchange transaction id (external_id) on withdrawals table after successful submit.
- Poll exchange API for status if no webhook, or use webhook to update status.
- Expose status to user and admin as read-only (pending, processing, completed, failed).

## 6. Retry logic

- Exponential backoff for transient errors (network, 5xx).
- Max retries (e.g. 5); then mark failed and notify admin.
- Ensure idempotency: same withdrawal request must not be sent twice; use idempotency key or DB state.

## 7. Failure handling

- On failure: update withdrawal status to failed; optionally credit balance back (business rule).
- Log full error and payload to audit_logs (redact secrets).
- Alert ops/admin for manual resolution (wrong address, insufficient liquidity, etc.).

## 8. Audit trail

- Log every withdrawal request, approval, API call (success/failure), and status change in audit_logs.
- Include actor (admin id), withdrawal id, amount, provider, external_id when available.
- Do not log API secrets.

## 9. Admin confirmation flow

- User requests withdrawal → status pending.
- Admin sees list in admin-withdrawals; clicks Approve or Reject.
- On Approve: deduct user balance (in transaction), set withdrawal to processing, push to queue.
- Worker performs exchange API call; on success set completed and set external_id; on failure set failed and optionally refund.
- Reject: set status rejected; no balance change.

## 10. No API logic in frontend

- Frontend only: submit withdrawal request (amount, provider), view history and status.
- Frontend never calls Binance/OKX APIs, never sees keys, never computes fees or final amounts; server returns only what user is allowed to see.
